

PROCEDURE DSIMPLEX(
       M,N,FOPT    :INTEGER;
   VAR A           :ARRMN;
   VAR U           :ARRN;
       EPS,INF     :REAL;
   VAR NOFEAS,NOSOL:BOOLEAN);

   VAR I,J,K,K1,K2,K3,K4,L,W:INTEGER;
       MIN,XM,XS            :REAL;
       B,STOP               :BOOLEAN;
       Z,Z1                 :ARRMIN;
BEGIN
   NOFEAS:=FALSE;  NOSOL:=FALSE;
   K4:=N-M;
   A[0,0]:=0.0;
   FOR I:=0 TO K4 DO BEGIN
      XS:=0.0;
      FOR J:=1 TO M DO XS:=XS+A[J,I]*A[0,K4+J];
      A[0,I]:=XS-A[0,I]
   END;
   FOR I:=K4+1 TO N DO
      FOR J:=1 TO M DO
         IF I = K4+J THEN A[J,I]:=1.0
         ELSE A[J,I]:=0.0;
   I:=0;
   WHILE (NOT NOFEAS) AND (I < K4) DO BEGIN
      I:=I+1;  XS:=A[0,I];
      NOFEAS:=(ABS(XS) > EPS) AND (XS*FOPT < 0);
      IF NOT NOFEAS THEN U[M+I]:=I
   END;
   IF NOT NOFEAS THEN BEGIN
      FOR I:=1 TO M DO U[I]:=K4+I;
      STOP:=FALSE;
      REPEAT  { UNTIL STOP }
         MIN:=0.0;  B:=TRUE;  I:=0;
         REPEAT  { UNTIL STOP OR (I >= M) }
            I:=I+1;  J:=M;  XS:=A[I,0];
            IF XS < -EPS THEN BEGIN
               STOP:=TRUE;
               WHILE (J < N) AND STOP DO BEGIN
                  J:=J+1;  W:=U[J];
                  STOP:=A[I,W] >= -EPS
               END;
               IF STOP THEN NOSOL:=TRUE
               ELSE BEGIN
                  B:=FALSE;
                  IF XS-MIN < -EPS THEN BEGIN
                     MIN:=XS;  L:=I
                  END
               END  { ELSE: NOT STOP }
            END  { IF XS < -EPS }
         UNTIL STOP OR (I >= M);
         IF NOT STOP THEN BEGIN
            IF B THEN BEGIN NOSOL:=FALSE;  STOP:=TRUE END
            ELSE BEGIN
               MIN:=INF;
               FOR J:=1 TO K4 DO Z1[J]:=M+J;
               FOR I:=0 TO M DO
                  IF (I <> 1) AND (NOT B) THEN BEGIN
                     K:=0;
                     FOR J:=1 TO K4 DO Z[J]:=Z1[J];
                     K3:=1;
                     FOR J:=M+1 TO N DO
                        IF J = Z[K3] THEN BEGIN
                           K3:=K3+1;  W:=U[J];  XS:=A[L,W];
                           IF XS < -EPS THEN BEGIN
                              XS:=ABS(A[I,W]/XS);  XM:=XS-MIN;
                              IF ABS(XM) < EPS THEN BEGIN
                                 K:=K+1;  Z1[K]:=J;
                                 B:=FALSE
                              END
                              ELSE
                                 IF XM < 0.0 THEN BEGIN
                                    MIN:=XS;  K1:=J;  K2:=W;
                                    Z1[1]:=1;  K:=1;
                                    FOR W:=2 TO K4 DO Z1[W]:=0;
                                    B:=TRUE
                                 END
                           END  { IF XS < -EPS }
                        END  { IF J = Z[K3], FOR J }
                  END;  { IF I <> 1 AND (NOT B), FOR I }
               MIN:=1.0/A[L,K2];
               U[K1]:=U[L];
               IF L = 0 THEN I:=1 ELSE I:=0;
               REPEAT
                  XS:=A[I,K2]*MIN;
                  A[I,0]:=A[I,0]-A[L,0]*XS;
                  FOR J:=M+1 TO N DO BEGIN
                     W:=U[J];
                     A[I,W]:=A[I,W]-A[L,W]*XS
                  END;
                  IF I = L-1 THEN I:=I+2 ELSE I:=I+1
               UNTIL I > M;
               FOR J:=M+1 TO N DO BEGIN
                  W:=U[J];
                  A[L,W]:=A[L,W]*MIN
               END;
               A[L,0]:=A[L,0]*MIN;
               FOR I:=0 TO M DO
                  IF I = 1 THEN A[I,K2]:=1.0
                  ELSE A[I,K2]:=0.0;
               U[L]:=K2
            END  { ELSE: NOT B }
         END  { IF NOT STOP }
      UNTIL STOP
   END  { IF NOT NOFEAS }
END;  { DSIMPLEX }
